import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

@SuppressWarnings("serial")
public class LightsOutApp extends JPanel implements MouseListener, MouseMotionListener, ActionListener
{
	public static int WIDTH=600;
	public static int HEIGHT=600;
	private Font titleFont, regularFont;
	private String message;
	private Button resetButton; 
	private int moves;
	private Puzzle puzzle;
	public static final int SIZE=60;
	public static final int DIMENSION=6;

	public LightsOutApp()
	{

		//initialize variables here...
		titleFont = new Font("Roman", Font.BOLD, 18);
		regularFont = new Font("Helvetica", Font.PLAIN, 12);
		//Setup Mouse listening:
		addMouseListener(this);
		addMouseMotionListener(this);
		//Setup Reset Button:
		resetButton = new Button("   Start   ");
		resetButton.addActionListener(this);
		add(resetButton);

		//Set up variables
		message="Press buttons until all are off";
		moves=0;
		puzzle = new Puzzle(DIMENSION, SIZE, 50, 70);
	}
	public static void main(String[] args) {
		LightsOutApp app= new LightsOutApp();
		JFrame window = new JFrame("Lights Out: click boxes untill they are all off");
		window.setSize(WIDTH, HEIGHT);
		window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		window.getContentPane().add(app);

		window.addMouseMotionListener(app);

		window.setVisible(true);

	}
	public void paintComponent(Graphics g){
		super.paintComponent(g);
		g.setColor(Color.WHITE);
		g.fillRect(0, 0, getWidth(),getHeight());
		g.setColor(Color.MAGENTA);
		g.setFont(titleFont);
		g.drawString("Lights Out!", 20, 20);
		g.setColor(Color.BLACK);
		g.setFont(regularFont);
		g.drawString(message, 20, 40);
		g.setColor(Color.BLUE);
		puzzle.draw(g);

	}
	// update is a workaround to cure Windows screen flicker problem
	public void update(Graphics g){
		paint(g);
	}
	/**
	 * These are the Methods needed to implement the  Interfaces
	 */

	public void mouseDragged(MouseEvent e) {


	}
	public void mouseMoved(MouseEvent e) {
		int x=e.getX();
		int y=e.getY();
		if (puzzle.contains(x, y)){
			puzzle.hoverOver(x,y);
			repaint();
		}
	}
	public void actionPerformed(ActionEvent e) {
		// resetButton pressed
		message=" 0 moves";
		moves=0;
		resetButton.setLabel("Start Over");
		puzzle = new Puzzle(DIMENSION, SIZE, 50, 70);
		repaint();

	}
	public void mouseClicked(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {
		int x=e.getX();
		int y=e.getY();
		if (puzzle.contains(x, y)){
			puzzle.clickOn(x,y);
			repaint();
		}
	}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}



}